#
#  MAILMAN - Manager module for Mailmatic
# Compose and send E-Mail to mailing list recipients
#
#     Filename: mailman.pl
#    Copyright: 1997,1998 by Joe DePasquale
# Last revised: April 7,1998
#       E-Mail: crypt@getcruising.com
#      Website: http://www.GetCruising.com
#
########################################################################
#                                                                      #
# This script and accompanying files may be distributed freely         #
# and modified, provided this header with my name, E-Mail address and  #
# this notice remain intact. Ownership rights remain with me. You may  #
# not sell this script without my approval.                            #
#                                                                      #
# This script comes with no guarantee or warranty except for my good   #
# intentions. By using this code you agree to indemnify me from any    #
# liability that might arise from it's use.                            #
#                                                                      #
# There is no technical support for this script, neither am I a        #
# professional programmer. Refer to 'HELPME.TXT' for further guidance. #
#                                                                      #
########################################################################

sub mailman {

&header;
&passtest ($MAILPWD);

##################################################################
# Case: SAVE MESSAGE saves the message only

if ($Form{'savemssg'})
{
  if ($Form{'message'})
  {
    open (TXT,">$MAILTXT") || &endMan ("Write: $MAILTXT");
    $subject = $Form{'subject'};
    $subject =~ s/\"/'/;
    if ($subject !~ /\n$/)
    { $subject = "$subject\n";
    }
    print (TXT $subject.$Form{'message'});
    close (TXT);
    print "MESSAGE TEXT has been saved as $MAILTXT.<br>\n";
    &editor;
  } else
  { &endMan ("No message text to save!");
  }
} # end Case SAVE MESSAGE

##################################################################
# Case: SEND MAIL processes the mailing

elsif ($Form{'sendmail'})
{
  if ($Form{'message'})
  {
    open (TXT,">$MAILTXT") || &endMan ("Write: $MAILTXT");
    $subject = $Form{'subject'};
    $subject =~ s/\"/'/;
    if ($subject !~ /\n$/)
    { $subject = "$subject\n";
    }
    print (TXT $subject.$Form{'message'});
    close (TXT);
  } elsif (!-s $MAILTXT)
  { &endMan ("Message text is blank, creep!");
  }
  $dateFlag = 'N'; $subjectFlag ='N';

  if ($Form{'startdate'} || $Form{'enddate'})
  { if ($Form{'startdate'} <= $Form{'enddate'})
    { $dateFlag = 'Y';
    } else
    { &endMan ("Mismatched dates $Form{'startdate'} - $Form{'enddate'}");
    }
  }
  if ($Form{'subjectkey'} && $Form{'subjectkey'} ne 'ALL')
  { $subjectFlag = 'Y';
  }
  open (LOCK,">$MAILFLK") || &endMan ("Write: $MAILFLK");
  if (!flock (LOCK,2)) { &endMan ("Lock: $MAILFLK"); }

  # If survey responses are rcvd during mail processing,
  # they will be appended to MAILHOLD.

  open (DAT,"<$MAILDAT") || &endMan ("Read: $MAILDAT");
  flock (DAT,1), seek (DAT,0,0);
  @listLines = <DAT>;
  close (DAT);

  open (TXT,"<$MAILTXT") || &endMan ("Read: $MAILTXT");
  @mssgLines = <TXT>;
  close (TXT);
  $subject = shift (@mssgLines);
  $subject =~ s/\n$//;

  # Now OK to allow access to DAT. Start sending mail.
  open (LOG,"+<$MAILLOG") || &endIt ("Read\/Write: $MAILLOG");
  flock (LOG,2); seek (LOG,0,0);
  print LOG "\nMailing started:\n $timeStamp\nIntended Recipients:\n";
  print "Mailing started: $timeStamp<br>\n";

  $recNbr = 0; $mailCnt =0;

  while ($recNbr <= $#listLines)
  { ($email,$name,$company,$subjectKeys,$lastdate,$eol) = split (/\|/,$listLines[$recNbr]);
    if (($dateFlag eq "N"
     || ($lastdate >= $Form{'startdate'} && $lastdate <= $Form{'enddate'}))
     && ($subjectFlag eq "N"
     || ($subjectKeys =~ /$Form{'subjectkey'}/)))
    {
      $bccList .= "$email, ";
      $listLines[$recNbr] =~ s/\|\d{8}\|/\|$dateStamp\|/;
      print LOG " $email,\n";
      $mailCnt++;
    }
    $recNbr++;
  }
  close (LOG);

  eval
  { open (MAIL,"|$mailCmd -t -oi") || &endIt ("Open on $mailCmd Failed");
    print MAIL "X-Mailer: MAILMATIC\n";
    print MAIL "X-Comment: MAILMATIC is FREE at http://www.GetCruising.com/crypt\n";
    print MAIL "To: $toMail\nFrom: $myMail\n";
    print MAIL "Bcc: $bccList\n";
    print MAIL "Subject: $subject\n\n";
    1;
  };
  if ($@) { &endMan ("Failed in Eval: $@"); }
  print (MAIL @mssgLines);

  print MAIL qq|\n* * * * * * * * * * * * * * *\n|;
  print MAIL qq|Thanks again for registering for the\n|;
  print MAIL qq|"$Subject{$Form{'subjectkey'}}" mailing list.\n\n|;
  print MAIL qq|If you do not want to receive \n|;
  print MAIL qq| future updates send me a note by E-Mail.\n|;
  print MAIL qq|Please come back and visit again soon!\n\n|;

  if (open (SIG,"<$MYSIG"))
  { @mySig = <SIG>;
    print MAIL "@mySig";
    close (SIG);
  } else
  { print MAIL "$myName <$myMail>\n$homeUrl\n";
  }
  close (MAIL);

  open (DAT,"+<$MAILDAT") || &endMan ("Read\/Write: $MAILDAT");
  flock (DAT,2); seek (DAT,0,0);
  $oldSize = @oldFile = <DAT>;
  $newSize = @listLines;

  if ($newSize == $oldSize)
  { seek (DAT,0,0);
    print (DAT @listLines);
    truncate (DAT,tell(DAT));
  }
  close (DAT);
  close (LOCK);

  print "Mail File contains <b>$newSize</b> records.<br>\n";
  print "<b>$mailCnt</b> E-Mail messages were processed and sent.</b><br>";
  print "MESSAGE TEXT has been saved as $MAILTXT.<p>\n";

  &editor;

} # End SENDMAIL

##################################################################
# Default Case: editor form

else
{ &editor;
} # end default
} # end mailman

##################################################################

sub editor # Print the editor form
{
  print qq|<form action="$scriptUrl" method=POST>\n|;
  print qq|<input type=hidden name=password value="$Form{'password'}">\n|;
  print qq|<input type=hidden name=manager value="1">\n|;

  if (-s $MAILTXT)
  { open (TXT,"<$MAILTXT") || &endMan ("Read: $MAILTXT");
    @message = <TXT>;
    close (TXT);
    $subject = shift (@message);
  } else
  { $subject = "UPDATE!\n";
  }
  print qq|<b>SUBJECT</b>:<br>\n|;
  print qq|<input type=text name=subject value="$subject" size=60 maxlength=90><br>\n|;
  print qq|<b>MESSAGE</b>:<br>\n|;
  print qq|<pre><textarea name=message cols=55 rows=10 wrap=PHYSICAL>|;

  print @message;

  print qq|</textarea></pre>\n<p>\n<b>Select by DATE RANGE</b>:<br>\n|;
  print qq|FROM: <input type=text name=startdate value="19960101" size=8 maxlength=8> \n|;
  print qq|  TO: <input type=text name=enddate value="$dateStamp" size=8 maxlength=8><br>\n|;

  print qq|<p><b>Select by SUBJECT KEYS</b>:<br>|;
  foreach $key (sort (keys %Subject))
  { print qq|<nobr>[<input type=radio name=subjectkey value="$key"|;
    if ($key eq $Form{'subjectkey'}) { print qq| checked|; }
    print qq|\> $Subject{$key} ]</nobr> \n|;
  }
  print qq|<nobr>[<input type=radio name=subjectkey value="ALL"> All Subjects ]</nobr> \n|;

  print qq|<hr><input type=submit name=sendmail value=" SEND "> \n|;
  print qq|<input type=submit name=savemssg value=" SAVE "> \n|;
  print qq|<input type=reset value="RESET"></form>\n|;
  print qq|<a href="$exitUrl">Exit $headTitle</a>\n|;
  print qq|<p><font size=2><i><b>MAILMATIC</b> is one of <a href="http://www.GetCruising.com/crypt" target="_top">Joe's CGI Scripts From The Crypt!</a></i></font>\n|;
  print qq|<p>\n</body></html>\n|;
} # end sub editor

sub passtest # test and/or change password 
{
  $PASSFILE = $_[0];
  if (-s $PASSFILE)
  { if ($Form{'password'})
    { open (PASS,"<$PASSFILE");
      $passcode = <PASS>;
      close (PASS);
      chop ($passcode) if $passcode =~ /\n$/;
      $lp = length $Form{'password'};
      $salt = substr($Form{'password'},$lp-2,1).substr($Form{'password'},1,1);
      if ($passcode eq crypt ($Form{'password'},$salt))
      { if ($Form{'newpassword'})
        { $lp = length $Form{'newpassword'};
          if ($Form{'newpassword'} =~ /^\w{$lp}\b/)
          { $Form{'password'} = $Form{'newpassword'};
            $salt = substr($Form{'password'},$lp-2,1).substr($Form{'password'},1,1);
            $passcode = crypt ($Form{'password'},$salt);
            open (PASS,">$PASSFILE");
            print PASS "$passcode";
            close (PASS);
          } else
          { &passbox ("Bad choice, Creep!!");
          }
        }
      } else
      { &passbox ("Wrong, Creep!!");
      }
    } else
    { &passbox ("What's the Password, Creep?");
    }
  } else
  { &endMan ("Password File $PASSFILE Not Found");
  }
}
sub passbox
{
  print qq|<form action="$scriptUrl" method="POST">\n|;
  print qq|<input type=hidden name=manager value="1"><table border=4>\n|;
  print qq|<tr><th colspan=2><font color="#FF0000"><b><blink>$_[0]</blink></b></font></th></tr>\n|;
  print qq|<tr><th>Enter Password:</td><th><input type=password name=password size=12 maxlength=12></th></tr>\n|;
  print qq|<tr><th>Change Password:</td><th><input type=text name=newpassword size=12 maxlength=12></th></tr>\n|;
  print qq|<th colspan=2><input type=submit value="  DO IT!  "><input type=reset value="  CLEAR  "></th></tr>\n|;
  print qq|</table><br>\nPassword must be 4 to 12 alpha-numeric characters.</form>\n<p>\n|;
  exit;
}

sub endMan # Error handling for manager scripts
{
  print qq|<font color="#FF0000"><b>ERROR:</font><br>$_[0]</b>\n<p>|;
  if ($!) { print qq|Server made a Boo-Boo! $!\n|; }
  else { print qq|Use your browser's [BACK] button and try again.\n|; }
  print qq|<p></body></html>\n|;
  exit;
} # end endMan

1; # return true
