#!/usr/bin/perl
#
# LINKMATIC WEB DIRECTORY
#
#    Filename : linkmat.cgi
#    Copyright: 1996,1997,1998 by Joe DePasquale
# Last revised: August 29, 1998
#       E-Mail: crypt@getcruising.com
#      Website: http://www.GetCruising.com
#
# See the document 'how2link.txt' for set-up instructions.
#
########################################################################
#                                                                      #
# This script and accompanying files may be distributed freely         #
# and modified, provided this header with my name, E-Mail address and  #
# this notice remain intact. Ownership rights remain with me. You may  #
# not sell this script without my approval.                            #
#                                                                      #
# This script comes with no guarantee or warranty except for my good   #
# intentions. By using this code you agree to indemnify me from any    #
# liability that might arise from it's use.                            #
#                                                                      #
# There is no technical support for this script, neither am I a        #
# professional programmer. Requests for technical assistance will be   #
# ignored. Refer to the resources on my website for further guidance.  #
#                                                                      #
########################################################################
#
# CONFIGURE THE SCRIPT:
#
# Change these sample paths to the actual paths on your server.

# Your Unix system date and sendmail commands
$dateCmd = '/bin/date';
$mailCmd = '/usr/sbin/sendmail';

# Your E-Mail address - note mandatory backslash before \@
$myMail = "yourmail\@your-server.com";

# Unix path to linkmat directory
$linkmatDir = '/usr/home/yourpath/to/linkmat';

# URL to linkmat directory
$linkmatUrl = 'http://www.your-server.com/linkmat';

# URL to linkmat.cgi
$scriptUrl = 'http://www.your-server.com/cgi-bin/linkmat.cgi';

# URL to exit from manager
$exitUrl = 'http://www.your-server.com/anypage.html';

# If you want a signature file attached to mail messages,
# uncomment the next line and enter the correct Unix path ..
$MYSIG = '/usr/home/yourpath/to/mysig.txt';

# .. otherwise uncomment the next lines and replace with your info ..
# $myName = 'Bonzo Clone';
# $homeUrl = 'http://www.your-server.com/anypage.html';

# Here you define one or more databases with a keyword and path to
# the directory where each can be found. The 'how2link.txt' document
# explains what to place in these directories that you will create
# in a later step. For simplicity use the keyword as the name
# of the directory (as below). Use short alphanumeric keywords.

%Script = (
 'cruising','/usr/home/yourpath/to/cruising',
 'rails','/usr/home/yourpath/to/rails',
);

# Select one of the above keywords as the default database.
$script = 'cruising';

# Maximum links to show per results page. If maxTtl is exceeded,
# user must use more specific search/browse query.
$maxPage = 40; $maxTtl = 400;

# END OF INSTALLATION - SHOULD NOT MESS WITH STUFF BELOW THIS LINE!
########################################################################

chop ($dateStamp = `$dateCmd +"%Y%m%d"`);
chop ($timeStamp = `$dateCmd +"%a %D %H%M%Z"`);

# Read and parse input from form

if (-e "./referer.pl")
{ require "./referer.pl";
  &referer;
}
print "Content-Type: text/html\n\n";

if ($ENV{'QUERY_STRING'})
{ $buffer = $ENV{'QUERY_STRING'};
} elsif ($ENV{'CONTENT_LENGTH'})
{ read (STDIN,$buffer,$ENV{'CONTENT_LENGTH'});
}
@cgiPairs = split(/&/,$buffer);
foreach $cgiPair (@cgiPairs)
{ ($name,$value) = split(/=/,$cgiPair);
  $name =~ s/\+/ /g; $value =~ s/\+/ /g;
  $name =~ s/%(..)/pack("c",hex($1))/ge;
  $value =~ s/%(..)/pack("c",hex($1))/ge;
  $Form{$name} .= "\0" if (defined($Form{$name}));
  $Form{$name} .= "$value";
  if ($name =~ /start(\d+).*/) { $Form{'start'} = $1; }
}
undef $name; undef $value;

# ensure a valid script is selected

if ($Script{$Form{'script'}})
{ $script = $Form{'script'};
}
$scriptDir = $Script{$script};

$LINKCFG = "$scriptDir/link.cfg";
$LINKADD = "$scriptDir/linkadd.dat";
$LINKDAT = "$scriptDir/link.dat";
$LINKFLK = "$scriptDir/link.flk";
$LINKTEMP = "$scriptDir/linktemp.html";

open (CFG,"<$LINKCFG") || &endIt ("Missing or Invalid Selection!");
@linkCfg = <CFG>;
close (CFG);

chop ($headTitle = shift (@linkCfg));
chop ($bodyTag = shift (@linkCfg));
chop ($bodyTitle = shift (@linkCfg));

for $x (0..$#linkCfg)
{ if ($linkCfg[$x] =~ /\S+/)
  { $cat[$x+10] = $linkCfg[$x];
    $cat[$x+10] =~ s/(\r|\n)//g;
  }
}
$thisUrl = "$linkmatUrl/pin-pur.gif";
$thatUrl = "$linkmatUrl/pin-grn.gif";
$hitCount = 0; # Initialize counter

if (defined $Form{'manager'})
{ $LINKPWD = "$linkmatDir/linkmat.pwd";
  require "./linkman.pl";
  &linkman;
  exit;
} # end manager

########################################################################
# Case: SEARCH for keywords

if ($Form{'search'})
{
  &header;
  if ($Form{'searchtext'})
  { if (length $Form{'searchtext'} >60)
    { &endIt ("Maximum length for search data exceeded.");
    }
  } else
  { &endIt ("The search data you entered was blank.");
  }
  @phrases = split (/\"/," $Form{'searchtext'} ");
  for ($x=0; $x<=$#phrases; $x++)
  { if (($x % 2==0) || $x==$#phrases)
    { @words = split (/ /,$phrases[$x]);
      foreach $word (@words)
      { if ($word =~ /\S{2,}/) { push @searchKey, $word; }
      }
    } elsif ($phrases[$x] =~ /\S{2,}/)
    { push @searchKey, $phrases[$x];
    }
  }
  if (!@searchKey) { &endIt ("No valid keywords were entered."); }

  &getStart;
  while ($recNbr <=$#linkFile && ($hitCount <$maxPage || ($startFlag eq 'Y' && $hitTotal <=$maxTtl)))
  {
    @link = split (/\|/,$linkFile[$recNbr]);
    $target = join (" ",@link[1..$#link-1]);

    if ($Form{'searchtype'} eq 'any') { $foundFlag = 'N'; } else { $foundFlag = 'Y'; }
    foreach $test (@searchKey)
    { if ($target =~ /$test/ || ($test eq lc($test) && $target =~ /$test/i))
      { if ($Form{'searchtype'} eq 'any') { $foundFlag = 'Y'; last; }
      } else
      { if ($Form{'searchtype'} eq 'all') { $foundFlag = 'N'; last; }
      }
    }
    if ($foundFlag eq 'Y')
    { if ($startFlag eq 'Y' && ($hitTotal % $maxPage ==0))
      { $hitStart .= ":$recNbr";
      }
      $hitTotal++;
      if ($hitTotal <=$maxPage) { $hitCount++; &printLink; }
    }
    $recNbr++;
  }
  &pageMenu;
  &footer;
} # end search

##################################################################
# Case: BROWSE by category

elsif ($Form{'browse'})
{
  &header;
  if ($Form{'category'})
  { @category = split (/\0/,$Form{'category'});
    foreach $test (@category)
    { if (!$cat[$test]) { &endIt ("Invalid category selection."); }
    }
  } else
  { &endIt ("No categories were selected.");
  }
  &getStart;
  while ($recNbr <=$#linkFile && ($hitCount <$maxPage || ($startFlag eq 'Y' && $hitTotal <=$maxTtl)))
  {
    foreach $test (@category)
    { if ($linkFile[$recNbr] =~ /^$test\|/)
      { @link = split (/\|/,$linkFile[$recNbr]);
        { if ($startFlag eq 'Y' && ($hitTotal % $maxPage ==0))
          { $hitStart .= ":$recNbr";
          }
          $hitTotal++;
          if ($hitTotal <=$maxPage) { $hitCount++; &printLink; }
        }
        last;
      }
    }
    $recNbr++;
  }
  &pageMenu;
  &footer;
} # end browse

##################################################################
# Case: NEW in past month

elsif ($Form{'new'})
{
  &header;
  if ($dateStamp %10000 <200)
  { $pastDate = $dateStamp -8900;
  } else
  { $pastDate = $dateStamp -100;
  }
  &getStart;

  while ($recNbr <=$#linkFile && ($hitCount <$maxPage || $startFlag eq 'Y'))
  { @link = split(/\|/,$linkFile[$recNbr]);
    if ($pastDate <= $link[6])

    { if ($startFlag eq 'Y' && ($hitTotal % $maxPage ==0))
      { $hitStart .= ":$recNbr";
      }
      $hitTotal++;
      if ($hitTotal <=$maxPage) { $hitCount++; &printLink; }
    }
    $recNbr++;
  }
  &pageMenu;
  &footer;
} # end new

##################################################################
# CASE: Request to ADD a URL

elsif ($Form{'add'})
{ 
  &header;
  if ($Form{'catnbr'} && $Form{'title'} && $Form{'siteurl'} && $Form{'description'} && $Form{'name'} && $Form{'email'})
  {
    @fields = ($Form{'catnbr'},$Form{'title'},$Form{'siteurl'},$Form{'description'},$Form{'name'},$Form{'email'});
    for $x (1..5)
    { $fields[$x] =~ s'&(amp;)?'&amp;'g;
      $fields[$x] =~ s'"'&quot;'g;
      $fields[$x] =~ s'\|'&#124;'g; # convert PIPE to html
      $fields[$x] =~ s/(\f|\n|\r|\t)//g; # delete formatting
    }
    if (!$cat[$fields[0]])
    { &endIt ("Invalid category selection.");
    } elsif ($fields[2] !~ /http:\/\/\S+?\.\S+/)
    { &endIt ("Invalid URL format.");
    } elsif (length $fields[3] >300)
    { $badLength = (length $fields[3]) -255;
      &endIt ("Description too long by $badLength characters.");
    } elsif ($fields[5] !~ /\S+?\@\S+?(\.\S+?)+/)
    { &endIt ("Invalid E-Mail format.");
    }
  } else
  { &endIt ("Incomplete information was submitted.");
  }
  $addLink = join ("\|",@fields,$dateStamp,"\n");

  open (ADD,"+>>$LINKADD") || &endIt;
  flock (ADD,2); seek (ADD,0,0);
  $addSize = @linkAdd = <ADD>;
  seek (ADD,0,2);
  print ADD $addLink;
  close (ADD);
  $addSize ++;

  open (MAIL,"|$mailCmd -t") || &endIt ("Mail Server Made A Boo-Boo! $!");
  print MAIL "To: $myMail\nFrom: $fields[5]\n";
  print MAIL "Subject: Add Link To $headTitle\n\n";
  print MAIL "A new link request has been received from\n$fields[1]\n\n";
  print MAIL "There are now $addSize requests pending action.\n";
  close (MAIL);

  print "<p><font size=5><b>Thank You!</b></font>\n";
  print "<p>\nYour request to add a link to\n <b>$headTitle</b> has been received:\n<p>\n";
  print "Category: $cat[$fields[0]]<br>\n";
  print "Title: $fields[1]<br>\nUrl: $fields[2]<br>\n";
  print "Description: $fields[3]<br>\n";
  print "Name: $fields[4]<br>\nE-Mail: $fields[5]<br>\n";
  print "Date: $dateStamp\n";
  print "<p>\nThe URL will be verified and when the site has been added notification will be sent by E-Mail. Completed on $timeStamp.\n";

  &footer;
} # end add

##################################################################
# CASE: Utility outputs a list of link categories and titles

elsif (defined $Form{'contents'})
{
  &header;
  print qq|<p>\nEnter <a href="$scriptUrl?script=$script"><b>$headTitle</b></a> |;
  print qq|for our <b>Current Contents</b>:\n<pre>\n|;

  open (DAT,"<$LINKDAT") || &endIt;
  flock (DAT,1); seek (DAT,0,0);

  while ($link = <DAT>)
  { @link = split (/\|/,$link);
    if ($catHeader ne $link[0])
    { $catHeader = $link[0];
      print "\n-&gt; $cat[$link[0]]\n";
    }
    print "$link[1]\n$link[3]\n";
    if ($link[7] !~ /\n$/) { print "$link[8]\n$link[9]\n"; }
  }
  close (DAT);
  print "</pre>\n";
  &footer;

} # end contents

##################################################################
# Default CASE: output the MAIN PAGE

else
{
  open (TEMP,"<$LINKTEMP");
  flock (TEMP,1); seek (TEMP,0,0);
  @tempFile = <TEMP>;
  close (TEMP);

  foreach $tempLine (@tempFile)
  { if ($tempLine =~ /<!-- LINKMATIC FORM - STARTS HERE -->/)
    {
      print qq|<form action="$scriptUrl" method="POST">\n|;
      print qq|<input type=hidden name=script value="$script">\n|;
    }
    elsif ($tempLine =~ /<!-- LINKMATIC BROWSE - STARTS HERE -->/)
    {
      $catSize = @cat -10;
      $last = $catSize %2;
      $rows = int ($catSize/2) + $last;
      $catNbr =10;
      for $row (1..$rows)
      { print "<tr valign=top>\n";
        print qq|<td><input type=checkbox name=category value="$catNbr">$cat[$catNbr]</td>\n|;
        $nextCol = $catNbr + $rows;
        if ($cat[$nextCol])
        { print qq|<td><input type=checkbox name=category value="$nextCol">$cat[$nextCol]</td>\n|;
        } else
        { print qq|<td>&nbsp;</td>\n|;
        }
        print "</tr>";
        $catNbr++;
      }
    }
    elsif ($tempLine =~ /<!-- LINKMATIC SELECTION BOX - STARTS HERE -->/)
    {
      print qq|<select name="catnbr" size=1>\n<option value="0" checked>Select A Category\n|;

      $catNbr =10;
      while ($cat[$catNbr])
      { print qq|<option value="$catNbr">$cat[$catNbr]\n|;
        $catNbr++;
      }
      print "</select>\n";
    } else
    { print "$tempLine";
    }
  }
} # end default

exit; # end main program

##################################################################

sub getStart
{
  open (DAT,"<$LINKDAT") || &endIt;
  flock (DAT,1); seek (DAT,0,0);
  $linkSize = @linkFile = <DAT>;
  close (DAT);

  # setup the hitcount buttons
  if (defined $Form{'start'})
  { $startFlag = 'N';
    @buttons = split (/:/,$Form{'hitstart'});
    $startBut = $Form{'start'};
    $startNbr = $buttons[$startBut];
  } else
  { $startFlag = 'Y';
    $startBut = 1;
    $startNbr = 0;
    $hitTotal = 0;
  }
  $recNbr = $startNbr;
} # end startcount

sub printLink
{
  if ($catHeader ne $link[0])
  { $catHeader = $link[0];
    $category = uc ($cat[$link[0]]);
    print qq|<hr>\n<font color="#000099" size=4><b><i>$category:</i></b></font>\n|;
  }
  print qq|<hr>\n<a href="$link[2]" target="_top"><b>$link[1]</b></a>\n|;
  if ($link[3]) { print qq| - $link[3] - \n|; }

  $linkDate = substr ($link[6],4,2)."/".substr ($link[6],6,2)."/".substr ($link[6],0,4);
  print qq|<font size="-1">$linkDate</font>\n|;

} # end printLink

sub pageMenu
{
  print "<hr>\n";

  if ($startFlag eq 'Y')
  { $Form{'hitstart'} = $hitStart;
    $Form{'hittotal'} = $hitTotal;
    @buttons = split (/:/,$Form{'hitstart'});
    if ($hitTotal >= $maxTtl)
    { print qq|\n<p>More than $maxTtl matches. Use more specific search or browse.|;
    }
  }
  print qq|\n<p>This page contains <b>$hitCount</b> of <b>$Form{'hittotal'}</b> matching records.<br>\n|;
  print qq|There are <b>$linkSize</b> records on file as of <b>$timeStamp</b>.<br>\n|;

  @linkStat = stat ($LINKDAT);
  @linkTime = localtime ($linkStat[9]);
  $linkDate = ($linkTime[4]+1)."/".$linkTime[3]."/".$linkTime[5];
  print qq|Database last updated <b>$linkDate</b>.<br>\n|;

  if ($Form{'hittotal'} >$maxPage)
  {
    print qq|<font size=2>Click any pin to browse more matches. <img src="$thisUrl" width=21 height=21 border=0 alt="You Are Here"> marks the current page.</font><br>\n|;
    print qq|<form action="$scriptUrl" method="POST">\n|;
    print qq|<input type=hidden name=script value="$script">\n|;
    print qq|<input type=hidden name=hitstart value="$Form{'hitstart'}">\n|;
    print qq|<input type=hidden name=hittotal value="$Form{'hittotal'}">\n|;

    if ($Form{'browse'})
    { print qq|<input type=hidden name=browse value='Y'>\n|;
      foreach $test (@category)
      { print qq|<input type=hidden name=category value="$test">\n|;
      }
    } elsif ($Form{'search'})
    { print qq|<input type=hidden name=search value='Y'>\n|;
      $Form{'searchtext'} =~ s'"'&quot;'g;
      print qq|<input type=hidden name=searchtext value="$Form{'searchtext'}">\n|;
      print qq|<input type=hidden name=searchtype value="$Form{'searchtype'}">\n|;
    }
    elsif ($Form{'new'})
    { print qq|<input type=hidden name=new value='Y'>\n|;
    }
    for $butNbr (1..$#buttons)
    { print "<font size=1>";
      if ($butNbr == $startBut)
      { print qq|$butNbr<input type=image src="$thisUrl" name="start$butNbr" border=0 alt="You Are Here">|;
      } else
      { print qq|$butNbr<input type=image src="$thatUrl" name="start$butNbr" border=0>|;
      }
      print "</font>\n";
    }
    print "</form>\n";
  }
} # end pageMenu

sub header
{
  print "<html>\n<head><title>$headTitle</title></head>\n";
  print "$bodyTag\n$bodyTitle\n<br>\n";
}

sub footer
{
  print qq|<p>\nBack to <a href="$scriptUrl?script=$script"><b>$headTitle</b></a>\n|;
  print qq|<p>\n<font size=2><i><b>LINKMATIC</b> is one of <a href="http://www.GetCruising.com/crypt" target="_top">Joe's CGI Scripts From The Crypt!</a></i></font>\n|;
  print qq|<p>\n</body></html>\n|;
} # end Sub Footer

sub endIt # Correctible user error
{
  print qq|<p><font color="#FF0000"><b>ERROR:</font><br>|;
  if ($_[0]) { print "$_[0]"; } else { print "Server made a Boo-Boo!"; }
  print "</b>\n<p>Use your browser's [BACK] button and try again.\n";
  print "<p>\n</body></html>\n";
  exit;
} # end endIt
