#
# LINKMAN - The Linkmatic Manager
#
#     Filename: linkman.pl
#    Copyright: 1997,1998 by Joe DePasquale
# Last revised: August 29, 1998
#       E-Mail: crypt@getcruising.com
#      Website: http://www.GetCruising.com
#
########################################################################
#                                                                      #
# This script and accompanying files may be distributed freely         #
# and modified, provided this header with my name, E-Mail address and  #
# this notice remain intact. Ownership rights remain with me. You may  #
# not sell this script without my approval.                            #
#                                                                      #
# This script comes with no guarantee or warranty except for my good   #
# intentions. By using this code you agree to indemnify me from any    #
# liability that might arise from it's use.                            #
#                                                                      #
# There is no technical support for this script, neither am I a        #
# professional programmer. Refer to 'HELPME.TXT' for further guidance. #
#                                                                      #
########################################################################

sub linkman {

&header;
&passtest ($LINKPWD);

foreach $key (keys %Form)
{ if ($key =~ /(action|text)\|(\d+)/)
  { $AddFile{$2}{$1} = $Form{$key};
  }
}

########################################################################
# Case: Edit temporary link file

if ($Form{'review'})
{
  open (ADD,"<$LINKADD") || &endMan ("Read :$LINKADD");
  flock (ADD,1); seek (ADD,0,0);
  $startSize = @linkAdd = <ADD>;
  close (ADD);

  if ($startSize <=0)
  { print "<p>No new records to process.\n<p>\n";
    &manager;
  }
  print qq|<font color="#0000FF">EDIT PENDING ADDITIONS TO $LINKDAT.</font>\n|;
  print qq|<p>\nThe record template is:<br>\n|; 
  print qq| CatNbr \| Title \| URL \| Description \| Name \| E-Mail \| DateStamp \|\n<hr>\n|;
  print qq|Categories: |;
  for $catNbr (10..$#cat) { print "$catNbr=$cat[$catNbr]&nbsp;;\n" ; }

  print qq|<form action="$scriptUrl" method=POST>\n|;
  print qq|<input type=hidden name=password value="$Form{'password'}">\n|;
  print qq|<input type=hidden name=manager value=1>\n|;
  print qq|<input type=hidden name=script value="$script">\n<hr>\n|;

  $addCnt =0;
  foreach $addLine (@linkAdd)
  { @addFields = split (/\|/,$addLine,4);
    $addLine =~ s/\n$//;
    print qq|<table border=0><tr valign=top>\n<td><b>\#$addCnt</b></td><td><a href="$addFields[2]">$addFields[2]</a></td></tr>\n|;
    print qq|<tr valign=top><td><input type=radio name="action\|$addCnt" value="accept"> Accept<br>\n|;
    print qq|<input type=radio name="action\|$addCnt" value="delete"> Delete<br>\n|;
    print qq|<input type=radio name="action\|$addCnt" value="ignore" checked> Ignore</td>\n|;
    print qq|<td><textarea name="text\|$addCnt" rows=5 cols=50 wrap=virtual>$addLine</textarea></td>\n</tr></table>\n<hr>\n|;
    $addCnt ++;
  }
  print qq|<input type=submit name=process value="GET IT DONE"> <input type=reset value=" RESET ">\n</form>\n|; 
  &manFooter;
} # end review

########################################################################
# Case: Add new records to database

elsif ($Form{'process'})
{
  open (LOCK,">$LINKFLK") || &endMan ("Write: $LINKFLK");
  if (!flock (LOCK,2)) { &endMan ("Lock: $LINKFLK"); }

  open (ADD,"+<$LINKADD") || &endMan ("Read\/Write: $LINKADD");
  flock (ADD,2); seek (ADD,0,0);
  $startSize = @linkAdd = <ADD>;
  $addCnt =0; $mailCnt =0; $deleteCnt =0;

  print "<b>Summary of records processed</b>:<br>\n";

  for $x (0..$#linkAdd)
  {
    if ($AddFile{$x}{'action'} eq 'accept')
    {
      $addLink = $AddFile{$x}{'text'};
      $addLink =~ s/(\f|\n|\r|\t)//g; # delete formatting
      @fields = split (/\|/,$addLink);

      open (DAT,"+>>$LINKDAT") || &endMan ("Read\/Append: $LINKDAT");
      flock (DAT,2); seek (DAT,0,2);
      print DAT "$addLink\n";
      close (DAT);

      if ($fields[5] =~ /\S+?\@\S+?(\.\S+?)+/)
      { if (open (MAIL,"|$mailCmd -t"))
        { print MAIL "To: $fields[5]\nFrom: $myMail\n";
          print MAIL "Subject: Your Link Has Been Accepted!\n\n";

          print MAIL "Your link has been added to\n$headTitle\nas shown here:\n\n";
          print MAIL "Title: $fields[1]\nURL: $fields[2]\n";
          print MAIL "Description: $fields[3]\nName: $fields[4]\n";
          print MAIL "E-Mail: $fields[5]\nDateStamp: $fields[6]\n\n";

          print MAIL "Note: Your name is not visible in the directory,\n";
          print MAIL "however it can be used in searches for your site.\n\n";
          print MAIL "Thank You!\nPlease keep a copy of this E-Mail for your records.\n";

          if (open (SIG,"<$MYSIG"))
          { @mySig = <SIG>;
            print MAIL "@mySig";
            close (SIG);
          } else
          { print MAIL "$myName <$myMail>\n$homeUrl\n";
          }
          close (MAIL);
          $mailCnt++;
        }
      }
      $addCnt ++;
    }
    if ($AddFile{$x}{'action'} ne 'ignore')
    { undef ($linkAdd[$x]);
      $deleteCnt ++;
    }
  }
  seek (ADD,0,0);
  print (ADD @linkAdd);
  truncate (ADD,tell(ADD)); close (ADD);

  &sort;
  close (LOCK);
  $endSize = $startSize - $deleteCnt;

  print " Of $startSize new links in $LINKADD ..<br>\n";
  print " $addCnt links added. ($mailCnt E-Mails sent)<br>\n";
  print " $deleteCnt links removed from temporary file.<br>\n $endSize links ignored.\n<p>\n";
  &manager;
} # end process

########################################################################
# Case: Sort the database

elsif ($Form{'sort'})
{
  &sort;
  &manager;
} # end sort

######################################################################
# case: View manager menu

else
{ &manager;
} # end manager
} # end linkman

######################################################################

sub manager # View link manager menu
{
  print qq|<form action="$scriptUrl" method=POST>\n|;
  print qq|<input type=hidden name=password value="$Form{'password'}">\n|;
  print qq|<input type=hidden name=manager value=1>\n<table border=1>\n|;
  print qq|<tr align=right><td>Select Database:</td><td>New Links</td><td>Filesize KB</td><td>Database KB</td></tr>\n|;

  foreach $scriptKey (keys %Script)
  { print qq|<tr align=right><td align=left><input type=radio name=script value="$scriptKey"|;
    if ($script eq $scriptKey) { print " checked"; }

    $scriptDir = $Script{$scriptKey};
    $LINKADD = "$scriptDir/linkadd.dat";
    $LINKDAT = "$scriptDir/link.dat";

    open (ADD,"<$LINKADD") || &endMan ("Read: $LINKADD");
    flock (ADD,1); seek (ADD,0,0);
    $addSize = @linkAdd = <ADD>;
    close (ADD);

    $addKb = (-s "$LINKADD");
    $datKb = (-s "$LINKDAT");
    print qq|\>$scriptKey</td><td>$addSize</td><td>$addKb</td><td>$datKb</td></tr>\n|;
  }
  print qq|</table><p>\n|;
  print qq|<input type=submit name=review value="VIEW NEW LINKS"> \n|;
  print qq|<input type=submit name=sort value="SORT DATABASE">\n</form><p>\n|;
  &manFooter;
} # end manager

sub sort # the database
{
  open (DAT,"+<$LINKDAT") || &endMan ("Read\/Write: $LINKDAT");
  flock (DAT,2); seek (DAT,0,0);
  $size = @unsorted = <DAT>;

  @sorted = sort {uc($a) cmp uc($b)} @unsorted;

  seek (DAT,0,0);
  print (DAT @sorted);
  truncate (DAT,tell(DAT)); close (DAT);

  print "$LINKDAT contains $size links.<br>\nFile has been sorted and saved.\n<p>\n";
} # end sort

sub manFooter
{
  print qq|<br>Completed on $timeStamp.\n|;
  print qq|<p><a href="$exitUrl">Exit LINKMATIC Manager</a>\n|;
  print qq|<p><font size=2><i><b>LINKMATIC</b> is one of <a href="http://www.GetCruising.com/crypt" target="_top">Joe's CGI Scripts From The Crypt!</a></i></font>\n|;
  print qq|<p></body></html>\n|;
  exit;
} # end footer

sub passtest # Test and/or change manager's password
{
  $PASSFILE = $_[0];
  if (-s $PASSFILE)
  { if ($Form{'password'})
    { open (PASS,"<$PASSFILE");
      $passcode = <PASS>;
      close (PASS);
      chop ($passcode) if $passcode =~ /\n$/;
      $lp = length $Form{'password'};
      $salt = substr($Form{'password'},$lp-2,1).substr($Form{'password'},1,1);
      if ($passcode eq crypt ($Form{'password'},$salt))
      { if ($Form{'newpassword'})
        { $lp = length $Form{'newpassword'};
          if ($Form{'newpassword'} =~ /^\w{$lp}\b/)
          { $Form{'password'} = $Form{'newpassword'};
            $salt = substr($Form{'password'},$lp-2,1).substr($Form{'password'},1,1);
            $passcode = crypt ($Form{'password'},$salt);
            open (PASS,">$PASSFILE");
            print PASS "$passcode";
            close (PASS);
          } else
          { &passbox ("Bad choice, Creep!!");
          }
        }
      } else
      { &passbox ("Wrong, Creep!!");
      }
    } else
    { &passbox ("What's the Password, Creep?");
    }
  } else
  { &endMan ("Password File $PASSFILE Not Found");
  }
}

sub passbox
{
  print <<__PASSBOX;
  <form action="$scriptUrl" method="POST">
  <input type=hidden name=manager value=1>
  <input type=hidden name=script value="$script">
  <table border=4>
  <tr><th colspan=2><font color="#FF0000"><b><blink>$_[0]</blink></b></font></th></tr>
  <tr><th> Enter Password:</td><th><input type=password name=password size=12 maxlength=12></th></tr>
  <tr><th>Change Password:</td><th><input type=text name=newpassword size=12 maxlength=12></th></tr>
  <th colspan=2><input type=submit value="  DO IT!  "><input type=reset value="  CLEAR  "></th></tr>
  </table><br>
  Password must be 4 to 12 alpha-numeric characters.</form>
  <p></body></html>
__PASSBOX
  exit;
}

sub endMan # Error handling for manager scripts
{
  print qq|<font color="#FF0000"><b>ERROR:</font><br>$_[0]</b>\n<p>|;
  if ($!) { print "Server made a Boo-Boo! $!\n"; }
  else { print "Use your browser's [BACK] button and try again.\n"; }
  print "<p></body></html>\n";
  exit;
} # end endMan

1; # return true
