#!/usr/bin/perl
#
# HITMATIC
# Maintains counts of pageviews and vistors on a website
# by day and by month for a year.
#
#     Filename: hitmat.cgi
# Last revised: October 8, 2006
#    Copyright: 1996-2006 by Joe DePasquale
#       E-Mail: crypt@getcruising.com
#      Website: http://www.getcruising.com
#
########################################################################
#                                                                      #
# This script and accompanying files may be distributed freely         #
# and modified, provided this header with my name, E-Mail address and  #
# this notice remain intact. Ownership rights remain with me. You may  #
# not sell this script without my approval.                            #
#                                                                      #
# This script comes with no guarantee or warranty except for my good   #
# intentions. By using this code you agree to indemnify me from any    #
# liability that might arise from it's use.                            #
#                                                                      #
# There is no technical support for this script, neither am I a        #
# professional programmer. Refer to 'HELPME.TXT' for further guidance. #
#                                                                      #
########################################################################
#
# 2. CONFIGURE SCRIPT -
#
# Change these sample paths to the actual paths on your server:

# Unix path to hitmat directory
$hitmatDir = '/your/path/to/web/hitmat';

#  OPTIONAL - You can edit these variables if desired:

# File Maintenance is triggered each day by the FIRST HIT after midnight
# and before $trigHour. This will 1) swap 'hit1.log' and 'hit2.log',
# 2) initialize a 'hitx.txt' file on the first day of a month and
# 3) analyze the day's log file and add the info to 'hitx.txt'. Use any
# 24-hour time from 1 (1 AM) to 23 (11 PM) or leave the default.
$trigHour = 23;

# [Optional] URL to stylesheet
$styleUrl = '/';

$headTitle = qq|HITMATIC Website Counter System|;
$bodyTag   = qq|<body class=g>|;
$bodyTitle = qq|<i><b><font size=5><font color="#0000FF">HIT</font><font color="#FF9900">MATIC</font></font></b></i>|;

# Go to this URL when exiting manager
$exitUrl = '/';

# Change the table border size? (0 = no border)
$border = 0;

# END OF INSTALLATION - SHOULD NOT CHANGE STUFF BELOW THIS LINE

########################################################################

($ss,$mm,$hh,$dd,$mo,$yyyy,$d,$jjj,$b) = localtime (time);
$mo++; $yyyy+=1900;

$timeStamp = localtime (time);
$scriptUrl = $ENV{'SCRIPT_NAME'};

$HITCFG = "$hitmatDir/hitcfg.txt";
$HITFLK = "$hitmatDir/hitflk.txt";
$HITLOG1 = "$hitmatDir/hit1.log";
$HITLOG2 = "$hitmatDir/hit2.log";
$HPMON = "$hitmatDir/hitp";
$HVMON = "$hitmatDir/hitv";
$HITPWD = "$hitmatDir/hitpwd.txt";
$HITGIF = "$hitmatDir/hit.gif";

########################################################################
# Read GET or POST input and setup stuff

if ($ENV{'QUERY_STRING'} eq 'manager' || $ENV{'REQUEST_METHOD'} eq 'POST')
{ require "hitman.pl";
  &hitman;
  exit;
} elsif ($ENV{'QUERY_STRING'} =~ /([^&+=]+)(\+([^&+=]+))?[=&]*/)
{ $page =$1; $group =$3; 
  $pagecode = "$group\+$page";
} else
{ &endIt;
}

open (LOCK,">$HITFLK") || &endIt;
if (!flock (LOCK,2)) { &endIt; }

# Daily maintenance if trigger time
if ($hh < $trigHour)
{ open (CFG,"+<$HITCFG") || &endIt;
  flock (CFG,2);
  seek (CFG,0,0);
  $cfgFile = <CFG>;
  ($logDay,$logMonth,$eol) = split (/\|/,$cfgFile);

  # If not done since midnight ...
  
  # If new day, add daily hits to month file
  if ($logDay+0 != $dd)
  { require "hitman.pl";
    &newDay;
  }
  # If new month, empty last year's month file and update cfg
  if ($logMonth+0 != $mo)
  { require "hitman.pl";
    &newMonth;
  }
  close (CFG);
}

# Send the Hit image to Stdout
$imageExt = substr ($HITGIF,rindex ($HITGIF,".")+1);

unless ($command eq 'IMG')
{ print "Content-type: image/$imageExt\n\n";
  open (GIF,"<$HITGIF");
  binmode (GIF);
  binmode (STDOUT);
  read (GIF,$buffer,-s $HITGIF);
  print $buffer;
  close (GIF);
}
# Record hit in the log
$hitLine = join ("\|",$timeStamp,$pagecode,$ENV{'REMOTE_ADDR'},$ENV{'HTTP_REFERER'},$ENV{'HTTP_USER_AGENT'});

if (open (LOG,">>$HITLOG1"))
{ flock (LOG,2);
  seek (LOG,0,2);
  print (LOG "$hitLine\n");
  close (LOG);
}
close (LOCK);
exit;

# end main program
######################################################################

sub endIt # exit on error
{ exit;
} # end endIt
