#!/usr/bin/perl
#
# BANNERMATIC 1 - Version using Server-Side-Includes
#
# Operates rotating banners and tracks display and click-thru stats.
#
#     Filename: banmat1.cgi
#    Copyright: 1997-2006 Joe DePasquale
# Last Revised: September 15, 2006
#       E-Mail: crypt@getcruising.com
#      Website: http://www.getcruising.com
#
# See the document 'how2ban.txt' for set-up instructions.
#
########################################################################
#                                                                      #
# This script and accompanying files may be distributed freely         #
# and modified, provided this header with my name, E-Mail address and  #
# this notice remain intact. Ownership rights remain with me. You may  #
# not sell this script without my approval.                            #
#                                                                      #
# This script comes with no guarantee or warranty except for my good   #
# intentions. By using this code you agree to indemnify me from any    #
# liability that might arise from it's use.                            #
#                                                                      #
# There is no technical support for this script, neither am I a        #
# professional programmer. Refer to 'HELPME.TXT' for general guidance. #
#                                                                      #
########################################################################
#
# CONFIGURE THE SCRIPT -
#
# Change these sample paths to the actual paths on your server:

# Your Unix system sendmail command and email address
$mailCmd = '/usr/sbin/sendmail';
$myMail = 'yourmail@yourdomain.com';

# Unix path to banmat data directory
$banmatDir = '/usr/home/yourpath/to/banmat';

# OPTIONAL - YOU CAN EDIT THESE VARIABLES IF DESIRED:

$headTitle = qq|BANNERMATIC1: SSI Version|;
$bodyTag = qq|<body bgcolor="#FFFFFF" text="#000099" link="#0000FF" alink="#FFFF00" vlink="#990000">|;
$bodyTitle = qq|<b><i><font size=5><font color="#0000FF">BANNERMATIC1 </font><font color="#006600">SSI Version</font></font></i></b>|;

# [Optional] URL to the styleheet
$styleUrl = '/www.css';

# If you want a signature file attached to mail messages,
# uncomment the next line and enter the correct Unix path ..
# $MYSIG = '/your/path/to/mysig.txt';

# .. otherwise uncomment the next 2 lines and replace with your info ..
# $myName = 'Bonzo Clone';
# $homeUrl = 'http://yourdomain.com/anypage.html';

# Go to this URL when exiting manager
$exitUrl = '/';

# END OF INSTALLATION - SHOULD NOT CHANGE STUFF BELOW THIS LINE
######################################################################

($ss,$mm,$hh,$dd,$mo,$yyyy,$d,$jjj,$b) = localtime (time);
$mo++; $yyyy+=1900;

$timeStamp = localtime (time);
$dateStamp = $yyyy.sprintf("%02d",$mo).sprintf("%02d",$dd);
$hourStamp = sprintf("%02d",$hh);
$dowStamp = $d;

$BANDAT = "$banmatDir/bandat.txt";
$BANFLK = "$banmatDir/banflk.txt";
$BANLOG = "$banmatDir/ban.log";
$BANUNDO = "$banmatDir/banmat.bak";
$BANPWD = "$banmatDir/banpwd.txt";
$scriptUrl = $ENV{'SCRIPT_NAME'};

######################################################################
# Get stuff and read input from query string

if ($ENV{'QUERY_STRING'} eq 'manager' || $ENV{'REQUEST_METHOD'} eq 'POST')
{ require "banman.pl";
  &banman;
  exit;
} elsif ($ENV{'QUERY_STRING'} =~ /(\S+?)=(\d+)(&.*|$)/)
{ $command =$1; $banNbr =$2;

  # Case: Send browser to the banner's URL
  if ($command eq 'URL')
  {
    open (LOCK,">$BANFLK") || &endIt;
    if (!flock (LOCK,2)) { &endIt; }

    # Get the banner info
    open (DAT,"+<$BANDAT") || &endIt;
    flock (DAT,2);
    seek (DAT,0,0);
    @banFile = <DAT>;

    if ($banNbr <= $#banFile)
    { @banLine = split (/\|/,$banFile[$banNbr]);
      # count the click-thru
      $banLine[2] ++;
      $banFile[$banNbr] = join ("\|",@banLine);
  
      seek (DAT,0,0);
      print (DAT @banFile);
      truncate (DAT,tell(DAT));

      # send browser to URL for the IMG
      print "Content-type: text/html\n";
      print "Location: $banLine[0]\n\n";

      # log the click-thru
      $banLog = join ("\|",$timeStamp,$banLine[0],$ENV{'REMOTE_ADDR'},$ENV{'HTTP_REFERER'});
      open (LOG,">>$BANLOG");
      flock (LOG,2);
      seek (LOG,0,2);
      print (LOG "$banLog\n");
      close (LOG);
    } else
    { print "Content-type: text/html\n\n";
      print "Banner Requested Does Not Exist ($banLine[0])<br>\n";
    }
    close (DAT);
    close (LOCK);
  } # end URL

  else
  { &endIt;
  }
} 

######################################################################
# Case: No querystring so output banner html

else
{ print "Content-type: text/html\n\n";

  open (LOCK,">$BANFLK") || &endIt;
  if (!flock (LOCK,2)) { &endIt; }

  # Get a random banner record
  open (DAT,"+<$BANDAT") || &endIt;
  flock (DAT,2);
  seek (DAT,0,0);
  @banFile = <DAT>;

  $banNbr = int (rand ($#banFile +1));
  @banLine = split (/\|/,$banFile[$banNbr]);

  # count the impression
  $banLine[3] ++;
  $banFile[$banNbr] = join ("\|",@banLine);

  seek (DAT,0,0);
  print (DAT @banFile);
  truncate (DAT,tell (DAT)); close (DAT);
  close (LOCK);

  print qq|<a href="$scriptUrl?URL=$banNbr"><font size=1>PLEASE CLICK TO VISIT OUR FRIENDS AT:</font><br>\n|;
  print qq|<img src="$banLine[1]" border=1 height=60 width=468></a>\n|;

} # end IMG

exit; # end program

######################################################################

sub endIt # error handling for user script
{ exit;
}
